<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Thrive_Apprentice\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Options callback for select2 fields assigned to lessons
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_thrive_apprentice_options_cb_lessons( $field ){

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any lesson', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    $course_id = absint( ct_get_object_meta( $field->object_id, 'course', true ) );
    
    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $lesson_id ) {

            // Skip option none
            if( $lesson_id === $none_value ) {
                continue;
            }
            
            $options[$lesson_id] = get_the_title( $lesson_id );
        }
}

return $options; 
}

/**
 * Get the course lessons
 *
 * @since 1.0.0
 *
 * @param int $course_id
 *
 * @return array
 */
function automatorwp_thrive_apprentice_get_lessons( $course_id ){

    $tva_lessons = array();

    $taxonomy = 'tva_courses';
    if ( class_exists( 'WP_Term' ) ) {
        $term_course = WP_Term::get_instance( $course_id, $taxonomy );
    } else {
        $term_course = get_term_by( 'id', $course_id, $taxonomy );
    }

    // To get all lessons
    $course = new TVA_Course_V2( (int) $course_id );
    $lessons = $course->get_all_lessons();
    
    foreach ( $lessons as $lesson ){
        $tva_lessons[] = array(
            'id' => $lesson->ID,
            'name' => $lesson->post_title,
        );
    }

    return $tva_lessons;
}

/**
 * Options callback for select2 fields assigned to modules
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_thrive_apprentice_options_cb_modules( $field ){

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any module', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    $course_id = absint( ct_get_object_meta( $field->object_id, 'course', true ) );
    
    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $module_id ) {

            // Skip option none
            if( $module_id === $none_value ) {
                continue;
            }
            
            $options[$module_id] = get_the_title( $module_id );
        }
}

return $options; 
}

/**
 * Get the module lessons
 *
 * @since 1.0.0
 *
 * @param int $course_id
 *
 * @return array
 */
function automatorwp_thrive_apprentice_get_modules( $course_id ){

    $tva_modules = array();

    $taxonomy = 'tva_courses';
    if (class_exists('WP_Term')) {
        $term_course = WP_Term::get_instance( $course_id, $taxonomy );
    } else {
        $term_course = get_term_by( 'id', $course_id, $taxonomy );
    }

    // To get all modules
    $modules = TVA_Manager::get_course_modules( $term_course );
    
    foreach ( $modules as $module ){
        $tva_modules[] = array(
            'id' => $module->ID,
            'name' => $module->post_title,
        );
    }

    return $tva_modules;
}
